/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.circuit.server;

import com.technicalitiesmc.scm.circuit.server.Circuit;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class CircuitCache {
    private static final Capability<CircuitCache> CIRCUIT_CACHE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<CircuitCache>(){});
    private final ServerLevel level;
    private Map<UUID, Circuit> circuits = new HashMap<UUID, Circuit>();
    private final ExecutorService threadPool = Executors.newCachedThreadPool();

    public CircuitCache(ServerLevel level) {
        this.level = level;
    }

    Circuit createUncached(UUID id) {
        Circuit circuit = new Circuit(this, id, false);
        this.level.m_8895_().m_164855_(CircuitCache.getPath(id), (SavedData)circuit);
        return circuit;
    }

    Circuit getOrCreate(UUID id) {
        return this.circuits.computeIfAbsent(id, $ -> (Circuit)this.level.m_8895_().m_164861_(t -> Circuit.load(this, id, t), () -> new Circuit(this, id, true), CircuitCache.getPath(id)));
    }

    private void tick() {
        boolean[] saved = new boolean[]{false};
        this.circuits.values().removeIf(c -> {
            if (!c.isLoaded()) {
                DimensionDataStorage storage = this.level.m_8895_();
                if (!saved[0]) {
                    saved[0] = true;
                    this.threadPool.submit(() -> ((DimensionDataStorage)storage).m_78151_());
                }
                storage.f_78144_.remove(CircuitCache.getPath(c.getId()));
                return true;
            }
            return false;
        });
        this.circuits = this.circuits.values().stream().filter(c -> !c.isInvalid()).map(Circuit::maybeSplit).flatMap(Collection::stream).collect(Collectors.toMap(Circuit::getId, Function.identity()));
        this.circuits.values().removeIf(c -> {
            if (c.isInvalid()) {
                this.level.m_8895_().m_164855_(CircuitCache.getPath(c.getId()), null);
                return true;
            }
            c.update();
            return false;
        });
    }

    private static String getPath(UUID id) {
        return "supercircuitmaker/circuit/" + id.toString().replace("-", "");
    }

    private static CircuitCache get(MinecraftServer server) {
        ServerLevel level = server.m_129783_();
        return (CircuitCache)level.getCapability(CIRCUIT_CACHE_CAPABILITY).orElse(null);
    }

    public static Circuit getOrCreate(MinecraftServer server, UUID id) {
        return CircuitCache.get(server).getOrCreate(id);
    }

    public static void tick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        CircuitCache.get(server).tick();
    }
}

